<?php defined( 'ABSPATH' ) or exit; ?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title><?php echo esc_html( $report_title ); ?></title>
	<style type="text/css">
		<?php echo $report_css; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</style>
</head>
<body>
	<!-- Report Header -->
	<div class="report-header">
		<div class="report-title"><?php echo esc_html( $report_title ); ?></div>

		<div class="report-meta">
			<table class="report-meta-table">
				<tr>
					<td class="report-meta-label"><?php echo esc_html( 'Plugin Version:' ); ?></td>
					<td class="report-meta-value"><?php echo esc_html( $plugin_version ); ?></td>
				</tr>
				<tr>
					<td class="report-meta-label"><?php echo esc_html( 'Store URL:' ); ?></td>
					<td class="report-meta-value"><?php echo esc_html( $store_url ); ?></td>
				</tr>
				<tr>
					<td class="report-meta-label"><?php echo esc_html( 'Report Date:' ); ?></td>
					<td class="report-meta-value"><?php echo esc_html( $report_date ); ?></td>
				</tr>
				<?php if ( ! empty( $report_user ) ) : ?>
					<tr>
						<td class="report-meta-label"><?php echo esc_html( 'Generated By:' ); ?></td>
						<td class="report-meta-value">
							<?php echo esc_html( $report_user->display_name . ' (' . $report_user->user_email . ')' ); ?>
						</td>
					</tr>
				<?php endif; ?>
			</table>
		</div>

		<!-- Paid Extensions section -->
		<div class="extensions-section">
			<div class="extensions-title"><?php echo esc_html( 'Installed Paid Extensions' ); ?></div>
			<ul class="extensions-list">
				<?php foreach ( $premium_plugins as $plugin ) : ?>
					<li>
						<span class="extension-name"><?php echo esc_html( $plugin['name'] ); ?></span>
						<?php echo esc_html( ' - v' . $plugin['version'] ); ?>

						<?php if ( isset( $plugin['is_active'] ) ) : ?>
							<?php if ( $plugin['is_active'] ) : ?>
								<span class="badge badge-enabled">Active</span>
							<?php else : ?>
								<span class="badge badge-disabled">Inactive</span>
							<?php endif; ?>
						<?php endif; ?>

						<?php if ( ! empty( $plugin['license_key'] ) && $include_sensitive ) : ?>
							<br><small><?php echo esc_html( 'License: ' . $plugin['license_key'] ); ?></small>
						<?php endif; ?>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
		
		<!-- Free Extensions section -->
		<div class="extensions-section">
			<div class="extensions-title"><?php echo esc_html( 'Installed Free Extensions' ); ?></div>
			<ul class="extensions-list">
				<?php foreach ( $free_extensions as $plugin ) : ?>
					<li>
						<span class="extension-name"><?php echo esc_html( $plugin['name'] ); ?></span>
						<?php echo esc_html( ' - v' . $plugin['version'] ); ?>

						<?php if ( isset( $plugin['is_active'] ) ) : ?>
							<?php if ( $plugin['is_active'] ) : ?>
								<span class="badge badge-enabled">Active</span>
							<?php else : ?>
								<span class="badge badge-disabled">Inactive</span>
							<?php endif; ?>
						<?php endif; ?>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
		
		<!-- Multilingual Plugins section -->
		<div class="extensions-section">
			<div class="extensions-title"><?php echo esc_html( 'Installed Multilingual Plugins' ); ?></div>
			<ul class="extensions-list">
				<?php foreach ( $multilingual_plugins as $plugin ) : ?>
					<li>
						<span class="extension-name"><?php echo esc_html( $plugin['name'] ); ?></span>
						<?php echo esc_html( ' - v' . $plugin['version'] ); ?>

						<?php if ( isset( $plugin['is_active'] ) ) : ?>
							<?php if ( $plugin['is_active'] ) : ?>
								<span class="badge badge-enabled">Active</span>
							<?php else : ?>
								<span class="badge badge-disabled">Inactive</span>
							<?php endif; ?>
						<?php endif; ?>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
	</div>

	<!-- System Configurations Section -->
	<div class="section">
		<div class="section-title"><?php echo esc_html( 'System Configurations' ); ?></div>

		<div class="system-info">
			<table class="config-table">
				<?php foreach ( $server_configs as $key => $value ) : ?>
					<tr>
						<td><?php echo esc_html( $key ); ?></td>
						<td><?php echo wp_kses_post( wpo_ips_format_report_setting_value( $value ) ); ?></td>
					</tr>
				<?php endforeach; ?>
			</table>
		</div>
		
		<?php if ( ! empty( $dir_permissions ) ) : ?>
			<div class="section-title"><?php echo esc_html( 'Directory Permissions' ); ?></div>

			<div class="system-info">
				<table class="config-table">
					<?php foreach ( $dir_permissions as $key => $value ) : ?>
						<tr>
							<td><?php echo esc_attr( $key ); ?></td>
							<td><?php echo wp_kses_post( wpo_ips_format_report_setting_value( $value ) ); ?></td>
						</tr>
					<?php endforeach; ?>
				</table>
			</div>
		<?php endif; ?>
		
		<div class="section-title"><?php echo esc_html( 'Yearly Reset Schedule' ); ?></div>

		<div class="system-info">
			<table class="config-table">
				<tr>
					<td><?php echo wp_kses_post( wpo_ips_format_report_setting_value( $yearly_reset['value'] ?? false ) ); ?></td>
				</tr>
			</table>
		</div>
	</div>

	<!-- Settings Groups Section -->
	<div class="section">
		<div class="section-title"><?php echo esc_html( 'Settings Groups' ); ?></div>

		<!-- General Settings Group -->
		<div class="settings-group">
			<div class="group-header"><?php echo esc_html( 'General Settings' ); ?></div>
			<table class="settings-table">
				<?php foreach ( $general_settings as $key => $value ) : ?>
					<tr>
						<td class="setting-name"><?php echo esc_attr( $key ); ?></td>
						<td class="setting-value"><?php echo wp_kses_post( wpo_ips_format_report_setting_value( $value ) ); ?></td>
					</tr>
				<?php endforeach; ?>
			</table>
		</div>
		
		<!-- Debug Settings Group -->
		<div class="settings-group">
			<div class="group-header"><?php echo esc_html( 'Debug Settings' ); ?></div>
			<table class="settings-table">
				<?php foreach ( $debug_settings as $key => $value ) : ?>
					<tr>
						<td class="setting-name"><?php echo esc_attr( $key ); ?></td>
						<td class="setting-value"><?php echo wp_kses_post( wpo_ips_format_report_setting_value( $value ) ); ?></td>
					</tr>
				<?php endforeach; ?>
			</table>
		</div>
		
		<!-- Documents Settings Group -->
		<?php foreach ( $documents_settings as $doc_type => $doc_settings ) : ?>
		<div class="settings-group">
			<div class="group-header"><?php echo esc_html( ucfirst( $doc_type ) . ' Settings' ); ?></div>
			<table class="settings-table">
				<?php foreach ( $doc_settings as $key => $value ) : ?>
					<tr>
						<td class="setting-name"><?php echo esc_attr( $key ); ?></td>
						<td class="setting-value"><?php echo wp_kses_post( wpo_ips_format_report_setting_value( $value ) ); ?></td>
					</tr>
				<?php endforeach; ?>
			</table>
		</div>
		<?php endforeach; ?>
		
		<!-- EDI Settings Group -->
		<div class="settings-group">
			<div class="group-header"><?php echo esc_html( 'E-Documents Settings' ); ?></div>
			<table class="settings-table">
				<?php foreach ( $edi_settings as $key => $value ) : ?>
					<tr>
						<td class="setting-name"><?php echo esc_attr( $key ); ?></td>
						<td class="setting-value"><?php echo wp_kses_post( wpo_ips_format_report_setting_value( $value ) ); ?></td>
					</tr>
				<?php endforeach; ?>
			</table>
		</div>
		
		<!-- Extensions Settings Group -->
		<?php if ( ! empty( $extensions_settings ) ) : ?>
			<?php foreach ( $extensions_settings as $slug => $settings ) : ?>
				<div class="settings-group">
					<div class="group-header"><?php echo esc_html( ucfirst( $slug ) . ' Settings' ); ?></div>
					<table class="settings-table">
						<?php foreach ( $settings as $key => $value ) : ?>
							<tr>
								<td class="setting-name"><?php echo esc_attr( $key ); ?></td>
								<td class="setting-value"><?php echo wp_kses_post( wpo_ips_format_report_setting_value( $value ) ); ?></td>
							</tr>
						<?php endforeach; ?>
					</table>
				</div>
			<?php endforeach; ?>
		<?php endif; ?>

	</div>
	
	<?php if ( ! empty( $logs_data ) ) : ?>
		<div class="section">
			<div class="section-title"><?php echo esc_html( 'Recent WooCommerce Logs' ); ?></div>

			<?php foreach ( $logs_data as $handle => $data ) : ?>
				<div class="settings-group">
					<div class="group-header">
						<?php echo esc_html( strtoupper( str_replace( '-', ' ', $handle ) ) ); ?>
						<small><?php echo esc_html( '(' . $data['file'] . ')' ); ?></small>
					</div>

					<?php if ( ! empty( $data['lines'] ) ) : ?>
						<pre class="log-output"><?php echo esc_html( implode( "\n", $data['lines'] ) ); ?></pre>
					<?php else : ?>
						<p><em><?php echo esc_html( 'No recent entries found.' ); ?></em></p>
					<?php endif; ?>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>


	<!-- Report Footer -->
	<div class="footer">
		<p><?php echo esc_html( 'This report was automatically generated by PDF Invoices & Packing Slips for WooCommerce' ); ?></p>
		<p>
			<?php
				printf(
					wp_kses_post( 'For assistance, please attach this report to your support email and send it to <a href="mailto:%1$s">%1$s</a>.' ),
					'support@wpovernight.com'
				);
			?>
		</p>
	</div>
</body>
</html>
